#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <contrib/restricted/spdlog/include/spdlog/sinks/base_sink.h>

namespace quasar::Logging {

    class IpcSink: public spdlog::sinks::base_sink<std::recursive_mutex> {
    public:
        IpcSink(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory, const std::string& serviceName);

    private:
        void sink_it_(const spdlog::details::log_msg& msg) override;
        void flush_() override;

    private:
        std::shared_ptr<ipc::IConnector> connector_;
    };

} // namespace quasar::Logging
