#pragma once

// Copyright(c) 2015-present, Gabi Melman & spdlog contributors.
// Distributed under the MIT License (http://opensource.org/licenses/MIT)

#pragma once

#include <spdlog/details/file_helper.h>
#include <spdlog/details/null_mutex.h>
#include <spdlog/details/synchronous_factory.h>
#include <spdlog/sinks/base_sink.h>

#include <chrono>
#include <mutex>
#include <string>

namespace spdlog_compat {

    using spdlog::filename_t;
    namespace details = spdlog::details;

} // namespace spdlog_compat

namespace spdlog_compat::sinks {

    using spdlog::sinks::base_sink;

    //
    // Rotating file sink based on size
    //
    // This sink differs from stock rotating_file_sink in that
    // it appends file index after file extension (like log4cxx)
    //
    template <typename Mutex>
    class rotating_file_sink final: public base_sink<Mutex> {
    public:
        rotating_file_sink(filename_t base_filename, std::size_t max_size, std::size_t max_files, bool rotate_on_open = false);
        static filename_t calc_filename(const filename_t& filename, std::size_t index);
        filename_t filename();

    protected:
        void sink_it_(const details::log_msg& msg) override;
        void flush_() override;

    private:
        // Rotate files:
        // log.txt -> log.txt.1
        // log.txt.1 -> log.txt.2
        // log.txt.2 -> log.txt.3
        // log.txt.3 -> delete
        void rotate_();

        // delete the target if exists, and rename the src file  to target
        // return true on success, false otherwise.
        bool rename_file_(const filename_t& src_filename, const filename_t& target_filename);

        filename_t base_filename_;
        std::size_t max_size_;
        std::size_t max_files_;
        std::size_t current_size_;
        details::file_helper file_helper_;
    };

    using rotating_file_sink_mt = rotating_file_sink<std::mutex>;
    using rotating_file_sink_st = rotating_file_sink<details::null_mutex>;

} // namespace spdlog_compat::sinks
