#include "telemetry_sink.h"

using namespace quasar::Logging;

TelemetrySink::TelemetrySink(std::shared_ptr<YandexIO::ITelemetry> telemetry)
    : telemetry_(std::move(telemetry))
{
}

void TelemetrySink::log(const spdlog::details::log_msg& msg) {
    static constexpr std::string_view MARKER_BEGIN = YIO_LOG_EVENT_MARKER;
    static constexpr std::string_view MARKER_END = YIO_LOG_EVENT_MARKER " ";

    try {
        auto jsonEventStr = std::string_view{};
        auto payload = std::string_view{msg.payload.data(), msg.payload.size()};
        if (payload.starts_with(MARKER_BEGIN)) {
            auto beginPos = MARKER_BEGIN.size();
            auto endPos = payload.find(MARKER_END, beginPos);
            if (endPos != std::string_view::npos) {
                jsonEventStr = payload.substr(beginPos, endPos);
                payload = payload.substr(endPos + MARKER_END.size());
            }
        }

        telemetry_->reportLogError(
            std::string(payload),
            msg.source.filename,
            msg.source.line,
            std::string(jsonEventStr));
    } catch (const std::exception&) {
        // avoid exceptions in logger
    }
}

void TelemetrySink::flush() {
}

void TelemetrySink::set_pattern(const std::string& pattern) {
    (void)pattern;
}

void TelemetrySink::set_formatter(std::unique_ptr<spdlog::formatter> sink_formatter) {
    (void)sink_formatter;
}
