#pragma once

#include <yandex_io/libs/logging/logging.h>

#include <yandex_io/libs/telemetry/telemetry.h>

#include <contrib/restricted/spdlog/include/spdlog/sinks/base_sink.h>

#include <memory>

namespace quasar::Logging {

    class TelemetrySink: public spdlog::sinks::sink {
    public:
        explicit TelemetrySink(std::shared_ptr<YandexIO::ITelemetry> telemetry);

        void log(const spdlog::details::log_msg& msg) override;
        void flush() override;
        void set_pattern(const std::string& pattern) override;
        void set_formatter(std::unique_ptr<spdlog::formatter> sink_formatter) override;

    private:
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
    };

} // namespace quasar::Logging
