#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/telemetry/telemetry.h>

#include <util/folder/path.h>

#include <mutex>
#include <string>

namespace quasar {

    class LoggingHandler {
    public:
        LoggingHandler() = default;
        ~LoggingHandler();

        void init(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory, const std::string& serviceName, const Json::Value& quasarConfig, std::shared_ptr<YandexIO::ITelemetry> telemetry);

    private:
        void reinitLoggingSubsystem();
        void onQuasarMessage(const ipc::SharedMessage& message);

        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::string serviceName_;
        TFsPath patchFilename_;
        std::shared_ptr<YandexIO::ITelemetry> telemetry_;

        std::mutex mutex_;
        bool started_{false};
        Json::Value originalConfig_;
        Json::Value finalConfig_;
        std::shared_ptr<ipc::IConnector> toSync_;
    };

} // namespace quasar
