#pragma once

#include <cstdint>
#include <memory>
#include <optional>

namespace quasar {
    class INsdReceiver;
    using INsdReceiverPtr = std::unique_ptr<INsdReceiver>;

    class INsdMessager {
    public:
        using OptBool = std::optional<bool>;
        virtual ~INsdMessager();
        virtual void enableNsd(bool guestMode, uint32_t port, OptBool stereopair, OptBool tandem) = 0;
        virtual void disableNsd() = 0;
    };

    using INsdMessagerPtr = std::shared_ptr<INsdMessager>;

    class INsdMessagerFactory {
    public:
        virtual ~INsdMessagerFactory();
        virtual INsdMessagerPtr createMessager(INsdReceiverPtr receiver) = 0;
    };
} // namespace quasar
