#pragma once

#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/libs/threading/periodic_executor.h>

#include <json/json.h>

#include <unordered_map>
#include <functional>

namespace quasar {

    class ClientStats {
    public:
        using Statistics = proto::MetricaMessage::Statistics;
        using OnStats = std::function<void(Json::Value)>;

        ClientStats(OnStats onStats);
        ~ClientStats();
        void processStatsMessage(const Statistics& stats);
        void applyConfig(const Json::Value& cfg);

    private:
        Json::Value statisticsEventPayload();

        OnStats onStats_;
        std::mutex statsMutex_;
        using StatsMap = std::unordered_map<std::string, std::vector<proto::MetricaMessage::StatsRecord>>;
        StatsMap clientStats_;
        std::unique_ptr<PeriodicExecutor> periodicExecutor_;
    };

} // namespace quasar
