#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>

#include <memory>
#include <mutex>
#include <optional>
#include <string>
#include <vector>

namespace quasar {

    class EventsDatabase {
    public:
        struct Event {
            uint64_t id{};
            quasar::proto::DatabaseMetricaEvent databaseMetricaEvent;
            Event(uint64_t id, quasar::proto::DatabaseMetricaEvent databaseMetricaEvent)
                : id(id)
                , databaseMetricaEvent(std::move(databaseMetricaEvent))
            {
            }
        };

        struct MPResult {
            size_t eventCount{0};
            size_t eventBytes{0};
            uint64_t eventMaxId{0};
        };

        using Filter = std::function<bool(uint64_t /*id*/, const proto::DatabaseMetricaEvent& /*event*/, bool /*saved*/)>;
        using TernaryFilter = std::function<std::optional<bool>(uint64_t /*id*/, const proto::DatabaseMetricaEvent& /*event*/, bool /*saved*/)>;
        struct DbParams {
            std::string path;
            int64_t maxSizeKB{-1};
            Filter filter;

            bool markAdd{false};
            std::string markBootPrefixPath;
        };
        EventsDatabase(std::string databasePath, uint64_t maxSizeKB);
        EventsDatabase(DbParams runtimeDb);
        EventsDatabase(DbParams runtimeDb, DbParams persistentDb);

        std::unique_ptr<Event> getEarliestEvent(const std::vector<uint64_t>& skipIds);
        void deleteEvents(const std::vector<uint64_t>& ids, bool useVacuum = true);
        uint64_t addEvent(const quasar::proto::DatabaseMetricaEvent& event);
        MPResult makePersistent(const Filter& filter, uint64_t fromId);
        const std::string& getDbFilename() const;
        uint64_t getDatabaseSizeInBytes();

    protected:
        EventsDatabase(std::vector<DbParams> dbParams);

    private:
        std::mutex mutex_;
        class DbSql;
        std::vector<std::shared_ptr<DbSql>> dbSqls_;
        uint64_t pk_{0};
        size_t lostEvents_{0};

        std::string instanceMark_;
    };
} // namespace quasar
