#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>

#include <string>

namespace quasar {

    class IMetricaConsumer {
    public:
        virtual ~IMetricaConsumer() = default;

        virtual void processEvent(const std::string& event, const std::string& eventValue, bool skipDatabase = false) = 0;
        virtual void processError(const std::string& error, const std::string& errorValue, bool skipDatabase = false) = 0;

        virtual void processStats(Json::Value payload) = 0;

        virtual void putEnvironmentVariable(const std::string& variableName, const std::string& variableValue) = 0;
        virtual void deleteEnvironmentVariable(const std::string& variableName) = 0;

        virtual void setConnectionType(proto::ConnectionType /*connectionType*/) = 0;

        virtual const std::string& getName() const = 0;
        virtual void processConfigUpdate(const Json::Value& configUpdate, const Json::Value& fullConfig) = 0;
    };

} // namespace quasar
