#pragma once

#include <mutex>
#include <random>

class MetricaSessionProvider {
public:
    struct Session {
        uint64_t id;
        uint64_t startTime;
        uint64_t eventNumber;
    };

    MetricaSessionProvider(std::string sessionIdPersistentPart, std::string sessionIdTemporaryPart);

    Session getAndIncrementSession();

    Session generateNewSession();

private:
    void initSession(bool resetTemporaryPart);

    static uint64_t readSessionIdPart(const std::string& path);

    static void saveSessionIdPart(const std::string& path, uint64_t oldSessionIdPart, uint64_t newSessionIdPart);

    static std::pair<uint64_t, uint64_t> incrementSessionIdParts(uint64_t persistentPart, uint64_t temporaryPart, bool resetTemporaryPart);

    static uint64_t getSessionId(uint64_t persistentPart, uint64_t temporaryPart);

    Session currentSession_;
    std::mt19937_64 generator_;
    const std::uniform_int_distribution<uint64_t> distribution_;
    std::mutex sessionMutex_;
    const std::string sessionIdPersistentPart_;
    const std::string sessionIdTemporaryPart_;
    bool isInitialized = false;
};
