#pragma once

#include "clickdaemon_sender.h"

#include <yandex_io/libs/metrica/base/events_database.h>
#include <yandex_io/libs/metrica/base/metrica_consumer.h>
#include <yandex_io/libs/metrica/base/metrica_router.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/metrics_collector/numeric_stat.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/periodic_executor.h>

#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class ClickdaemonConsumer: public IMetricaConsumer {
    public:
        static const std::string CONSUMER_NAME;

        ClickdaemonConsumer(const Json::Value& config, std::shared_ptr<YandexIO::IDevice> device);
        ~ClickdaemonConsumer();

        // IMetricaConsumer implementation
        void processEvent(const std::string& event, const std::string& eventValue, bool skipDatabase = false) override;
        void processError(const std::string& error, const std::string& errorValue, bool skipDatabase = false) override;

        void processStats(Json::Value payload) override;

        void putEnvironmentVariable(const std::string& variableName, const std::string& variableValue) override;
        void deleteEnvironmentVariable(const std::string& variableName) override;

        void setConnectionType(proto::ConnectionType connectionType) override;

        const std::string& getName() const override;
        void processConfigUpdate(const Json::Value& configUpdate, const Json::Value& fullConfig) override;

    private:
        void setEnabled(bool value);
        void sendMetrica(quasar::PeriodicExecutor* executor);
        void sendDbSize();

    protected:
        std::shared_ptr<MetricaBlockingQueue> immediateQueue_;
        std::shared_ptr<quasar::EventsDatabase> dbQueue_;

    private:
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        quasar::NumericStat<int> dbSize_;
        std::mutex dbSizeMutex_;

        std::mutex importantEventsMutex_;
        std::shared_ptr<const std::unordered_set<std::string>> importantEvents_;

        std::unique_ptr<MetricaRouter> metricaRouter_;
        std::unique_ptr<ClickdaemonSender> metricaSender_;

        std::atomic_bool enabled_;

        std::unique_ptr<quasar::PeriodicExecutor> sendMetricaExecutor_;
        std::unique_ptr<quasar::PeriodicExecutor> sendDbSizeExecutor_;
    };

} // namespace quasar
