#include "clickdaemon_metadata.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/base/persistent_file.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("clickdaemon");

using namespace quasar;

Json::Value ClickdaemonMetadata::toJson() const {
    Json::Value json;
    json["UUID"] = UUID;
    return json;
}

ClickdaemonMetadata ClickdaemonMetadata::fromJson(const Json::Value& json) {
    ClickdaemonMetadata metadata;
    metadata.UUID = getString(json, "UUID");
    return metadata;
}

ClickdaemonMetadata ClickdaemonMetadata::load(const std::string& metadataPath) {
    ClickdaemonMetadata metadata;

    try {
        Json::Value json = readJsonFromFile(metadataPath);
        metadata = ClickdaemonMetadata::fromJson(json);
    } catch (const std::exception& e) {
        YIO_LOG_ERROR_EVENT("ClickdaemonConsumer.LoadMetadata", "Failed to load clickdaemon metadata: " << e.what())
    }

    if (metadata.UUID.empty()) {
        metadata.UUID = makeUUID();
        YIO_LOG_INFO("Created new metrica UUID: " << metadata.UUID);

        try {
            AtomicFile file(metadataPath);
            file.write(jsonToString(metadata.toJson()));
        } catch (const std::exception& e) {
            YIO_LOG_ERROR_EVENT("ClickdaemonConsumer.SaveMetaData", "Failed to save clickdaemon metadata: " << e.what())
        }
    }

    return metadata;
}
