#pragma once

#include <yandex_io/libs/metrica/base/events_database.h>
#include <yandex_io/libs/metrica/base/metrica_queue.h>
#include <yandex_io/libs/metrica/clickdaemon/clickdaemon_sender_base.h>
#include <yandex_io/libs/metrica/clickdaemon/clickdaemon_metadata.h>

#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/counters/default_daily_counter.h>

#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class ClickdaemonSender {
        using DatabaseMetricaEvent = quasar::proto::DatabaseMetricaEvent;

    public:
        enum ConnectionType: int { /* Should be in sync with https://a.yandex-team.ru/arc/trunk/arcadia/infra/proto_logger/api/api.proto?rev=r7740250#L15 */
                                   CONNECTION_CELL = 0,
                                   CONNECTION_WIFI = 1,
                                   CONNECTION_UNDEFINED = 2,
                                   CONNECTION_BLUETOOTH = 3,
                                   CONNECTION_ETHERNET = 4
        };

        ClickdaemonSender(
            std::string endpointUri, size_t batchSize,
            std::shared_ptr<MetricaBlockingQueue> immediateQueue,
            std::shared_ptr<EventsDatabase> dbQueue,
            ClickdaemonMetadata metadata,
            std::shared_ptr<YandexIO::IDevice> device);
        ~ClickdaemonSender();

        size_t flushEvents();

        void setEndpointUri(const std::string& value);
        void setEventsBatchSize(size_t value);
        void setEnvKeysBlacklist(std::unordered_set<std::string> envKeysBlacklist);
        void setEventImportantList(std::shared_ptr<const std::unordered_set<std::string>> importantEvents);
        Json::Value getStatsPayload();

    private:
        size_t makePersistent();
        void immediateSendLoop();

        std::map<std::string, std::string> filterEnvironment(const std::map<std::string, std::string>& environmentVariables);

        std::string getEndpointUri() const;
        bool sendEvents(std::vector<quasar::proto::DatabaseMetricaEvent> events, std::map<std::string, std::string> environmentVariables);

    private:
        mutable std::mutex endpointUriMutex_;
        std::string endpointUri_;

        bool isStopped_;
        std::mutex mutex_;
        quasar::SteadyConditionVariable cond_;

        std::shared_ptr<MetricaBlockingQueue> immediateQueue_;
        std::shared_ptr<quasar::EventsDatabase> dbQueue_;
        uint64_t maxEventId_{0};
        BackoffRetriesWithRandomPolicy delayTimingsPolicy_;
        const ClickdaemonSenderBase::DeviceInfo deviceInfo_;
        ClickdaemonSenderBase realSender_;
        std::thread immediateSend_;

        std::atomic_size_t eventsBatchSize_;

        std::mutex eventListsMutex_;
        std::unordered_set<std::string> envKeysBlacklist_;
        std::shared_ptr<const std::unordered_set<std::string>> importantEvents_;

        enum Counters {
            IMMEDIATE,
            FROMDB,
            MAX_
        };

        using DailyCounter = quasar::DefaultDailyCounter<Counters>;
        using StatsCounter = typename DailyCounter::CounterType;
        DailyCounter dailyStats_;
    };

} // namespace quasar
