#pragma once

#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <map>

namespace quasar {
    class ClickdaemonSenderBase {
    public:
        struct DeviceInfo {
            std::string deviceId;
            std::string platform;
            std::string softwareVersion;
            std::string uuid;
        };

        ClickdaemonSenderBase(std::shared_ptr<YandexIO::IDevice> device, HttpClient::CalcRetryDelayFunction delayFunc);
        ClickdaemonSenderBase(std::shared_ptr<YandexIO::IDevice> device, HttpClient::CalcRetryDelayFunction delayFunc, bool keepAlive);
        ~ClickdaemonSenderBase();

        bool sendEvents(const std::string& endpointUri, std::vector<quasar::proto::DatabaseMetricaEvent> events, std::map<std::string, std::string> environmentVariables, const DeviceInfo& deviceInfo);

        struct EventsWithCommonEnv {
            std::vector<proto::DatabaseMetricaEvent::NewEvent> events;
            proto::DatabaseMetricaEvent::NewEnvironment env;
        };

        bool sendEvents(const std::string& endpointUri, const std::vector<EventsWithCommonEnv>& events, const DeviceInfo& deviceInfo);

    private:
        bool realSend(const std::string& endpointUri, const std::string& compressedRequest);

        HttpClient httpClient_;
    };
} // namespace quasar
