#pragma once

#include <yandex_io/libs/threading/i_callback_queue.h>

namespace YandexIO {
    class ThrottledCallable {
        std::shared_ptr<quasar::ICallbackQueue> queue_;
        std::mutex mutex_;
        bool stopped_{false};
        bool shouldBeRun_{false};
        bool running_{false};
        std::function<void()> callback_;
        const bool doLastCall_{false};

        void run();

    public:
        ThrottledCallable(std::shared_ptr<quasar::ICallbackQueue> queue, std::function<void()> cb, bool doLastCall);
        ~ThrottledCallable();

        void call();
    };
} // namespace YandexIO
