#pragma once
#include <string>
#include <vector>

namespace quasar {
    struct DiskStatsInfo {
        static constexpr size_t SECTORS_PER_KB = 2;
        static DiskStatsInfo getDiskStatsInfo(const std::vector<std::string>& disksList, int64_t uptime);

        struct DiskStats {
            // refer to kernel/Documentation/iostats.txt
            enum {
                ST_DEV_NAME = 2,
                ST_RD_COMPLETE = 3,
                ST_RD_SECTORS = 5,
                ST_WR_COMPLETE = 7,
                ST_WR_SECTORS = 9,
                ST_LAST,
            };

            int64_t rdOps = 0;
            int64_t rdSectors = 0;
            int64_t wrOps = 0;
            int64_t wrSectors = 0;
        };

        struct DiskDevice {
            int64_t readsPerSecKB() const;
            int64_t writesPerSecKB() const;

            std::string name;
            int64_t uptime;
            DiskStats stats;
        };

        std::vector<DiskDevice> devices;
    };

} // namespace quasar
