#pragma once
#include <string>
#include <vector>

namespace quasar {
    struct UbiInfo {
        static UbiInfo getUbiInfo(const std::vector<std::string>& disksList, int64_t uptime);
        static std::vector<std::pair<std::string, int64_t>> getNumericStats(const std::vector<std::string>& disksList, int64_t uptime);

        struct Stats {
            enum {
                RBYTES = 0,
                WBYTES = 1,
                RCOUNT = 2,
                WCOUNT = 3,
                LAST,
            };

            int64_t rbytes = 0;
            int64_t wbytes = 0;
            int64_t rcount = 0;
            int64_t wcount = 0;
        };

        struct Device {
            int64_t readsPerSecKB() const;
            int64_t writesPerSecKB() const;

            std::string name;
            int64_t uptime;
            Stats stats;
        };

        std::vector<Device> devices;
    };

} // namespace quasar
