#include "json_metric_consumer.h"

using namespace quasar;

namespace {
    template <typename T>
    void setJsonSimpleValue(Json::Value& json, std::string_view name, T value) {
        json[std::string(name)] = std::move(value);
    }

    template <typename T>
    void setJsonStatValue(Json::Value& json, std::string_view name, const NumericStat<T>& value) {
        auto& aggregate = json[std::string(name)];
        aggregate["min"] = value.getMin();
        aggregate["max"] = value.getMax();
        aggregate["mean"] = value.getMean();
        aggregate["last"] = value.getLast();
    }
} // namespace

JsonMetricConsumer::JsonMetricConsumer(Json::Value& targetValue)
    : targetValue_(&targetValue)
{
}

void JsonMetricConsumer::addDGauge(std::string_view name, double value) {
    setJsonSimpleValue(*targetValue_, name, value);
}

void JsonMetricConsumer::addIGauge(std::string_view name, int64_t value) {
    setJsonSimpleValue(*targetValue_, name, value);
}

void JsonMetricConsumer::addJson(std::string_view name, Json::Value value) {
    setJsonSimpleValue(*targetValue_, name, std::move(value));
}

void JsonMetricConsumer::addDGaugeStat(std::string_view name, const NumericStat<double>& value) {
    setJsonStatValue(*targetValue_, name, value);
}

void JsonMetricConsumer::addIGaugeStat(std::string_view name, const NumericStat<int64_t>& value) {
    setJsonStatValue(*targetValue_, name, value);
}
