#pragma once

#include <yandex_io/libs/metrics_collector/i_metric_consumer.h>

namespace quasar {

    class JsonMetricConsumer: public IMetricConsumer {
        Json::Value* targetValue_ = nullptr;

    public:
        JsonMetricConsumer(Json::Value& targetValue);

        void addDGauge(std::string_view name, double value) override;
        void addIGauge(std::string_view name, int64_t value) override;
        void addDGaugeStat(std::string_view name, const NumericStat<double>& value) override;
        void addIGaugeStat(std::string_view name, const NumericStat<int64_t>& value) override;
        void addJson(std::string_view name, Json::Value value) override;
    };

} // namespace quasar
