#include "aggregate_stat_metric_consumer.h"

using namespace quasar;

namespace {
    template <typename T>
    void updateStat(std::map<std::string, NumericStat<T>>& stats, std::string_view name, T value) {
        stats[std::string(name)].process(value);
    }

    template <typename T>
    void updateStat(std::map<std::string, NumericStat<T>>& stats, std::string_view name, const NumericStat<T>& value) {
        stats[std::string(name)].processStat(value);
    }
} // namespace

void AggregateStatMetricConsumer::clear() {
    iStats_.clear();
    dStats_.clear();
}

void AggregateStatMetricConsumer::provideStats(IMetricConsumer& downstream) {
    for (auto& [name, stat] : dStats_) {
        downstream.addDGaugeStat(name, stat);
    }

    for (auto& [name, stat] : iStats_) {
        downstream.addIGaugeStat(name, stat);
    }
}

void AggregateStatMetricConsumer::flush(IMetricConsumer& downstream) {
    provideStats(downstream);
    clear();
}

void AggregateStatMetricConsumer::addDGauge(std::string_view name, double value) {
    updateStat(dStats_, name, value);
}

void AggregateStatMetricConsumer::addIGauge(std::string_view name, int64_t value) {
    updateStat(iStats_, name, value);
}

void AggregateStatMetricConsumer::addDGaugeStat(std::string_view name, const NumericStat<double>& value) {
    updateStat(dStats_, name, value);
}

void AggregateStatMetricConsumer::addIGaugeStat(std::string_view name, const NumericStat<int64_t>& value) {
    updateStat(iStats_, name, value);
}

void AggregateStatMetricConsumer::addJson(std::string_view /* name */, Json::Value /* value */) {
    throw std::logic_error("JSON values not supported by AggregateStatMetricConsumer");
}
