#pragma once

#include <yandex_io/libs/metrics_collector/i_metric_consumer.h>

namespace quasar {

    class AggregateStatMetricConsumer: public IMetricConsumer {
        std::map<std::string, NumericStat<int64_t>> iStats_;
        std::map<std::string, NumericStat<double>> dStats_;

    public:
        // Erase all saved stats
        void clear();

        // Provide collected stats to downstream
        void provideStats(IMetricConsumer& downstream);

        // Provide collected stats to downstream and erase all saved stats
        // A convenience method, since that's what would be needed most of the time
        void flush(IMetricConsumer& downstream);

        // Update corresponding stats with a single value
        void addDGauge(std::string_view name, double value) override;
        void addIGauge(std::string_view name, int64_t value) override;

        // Update corresponding stats with a new summary
        void addDGaugeStat(std::string_view name, const NumericStat<double>& value) override;
        void addIGaugeStat(std::string_view name, const NumericStat<int64_t>& value) override;

        // Not supported: throws std::logic_error
        void addJson(std::string_view name, Json::Value value) override;
    };

} // namespace quasar
