#pragma once

#include <yandex_io/protos/quasar_proto.pb.h>

#include <json/json.h>

namespace quasar {

    class IMetricsCollector {
    public:
        virtual ~IMetricsCollector();

        virtual Json::Value getMetrics() = 0;
        virtual Json::Value getNetworkMetrics() = 0;

        virtual void setConfig(const Json::Value& config) = 0;
        virtual void setNetworkStatus(const proto::NetworkStatus& status) = 0;
    };

} // namespace quasar
