#pragma once

#include <algorithm>
#include <limits>

namespace quasar {

    template <typename Number>
    class NumericStat {
    public:
        void process(Number n) {
            last = n;
            sum += n;
            ++count;
            max = std::max(max, n);
            min = std::min(min, n);
        }

        void processStat(const NumericStat<Number>& stat) {
            last = stat.last;
            sum += stat.sum;
            count += stat.count;
            max = std::max(max, stat.max);
            min = std::min(min, stat.min);
        }

        Number getLast() const {
            return last;
        }

        Number getMax() const {
            return max;
        }

        Number getMin() const {
            return min;
        }

        double getMean() const {
            if (count != 0) {
                return double(sum) / count;
            }

            return 0;
        }

        void reset() {
            last = 0;
            last = 0;
            max = std::numeric_limits<Number>::min();
            min = std::numeric_limits<Number>::max();
            sum = 0;
            count = 0;
        }

    private:
        Number last = 0;
        Number max = std::numeric_limits<Number>::min();
        Number min = std::numeric_limits<Number>::max();
        Number sum = 0;
        int64_t count = 0;
    };

} // namespace quasar
