#pragma once

#include "net_utils.h"

#include <chrono>
#include <functional>
#include <mutex>
#include <thread>
#include <vector>

namespace quasar {

    class Beacon {
    public:
        Beacon(int port, std::vector<char> responseMessage);
        ~Beacon();

        bool start();
        bool stop();

        static bool impulse(
            const InterfaceConfig& iface,
            int port,
            std::chrono::milliseconds timeout,
            const std::function<void(const std::string&, const std::vector<char>&)>& responseHandler);

    private:
        void worker();

    private:
        const int port_;
        const std::vector<char> responseMessage_;

        std::mutex workerMutex_;
        int shutdownFd_{-1};
        std::thread workerThread_;
        int listenFd_{-1};
        std::vector<int> broadcastFds_;
    };

} // namespace quasar
