#pragma once

#include <optional>
#include <string>
#include <utility>
#include <vector>

struct sockaddr;
struct sockaddr_in;

namespace quasar {

    std::string getMyIp() noexcept;
    std::string getDefaultGatewayIp() noexcept;
    std::string toIpAddress(const struct sockaddr& addr) noexcept;
    std::string toIpAddress(const struct sockaddr_in& addr) noexcept;

    struct InterfaceConfig {
        std::string name;
        std::string ip;
        std::string netmask;
        std::string broadcast;
        std::string ptp;

        bool operator<(const InterfaceConfig& other) const noexcept;
    };
    std::vector<InterfaceConfig> interfaceConfigList() noexcept;
    std::vector<InterfaceConfig> findInterface(const std::string& anyInterfaceIdentifier) noexcept;
    std::vector<InterfaceConfig> broadcastAddresses(std::string ipAddress) noexcept;

    struct RouteInterface {
        std::string destinationIp;
        std::string sourceIp;
        std::string gatewayIp;
        std::optional<InterfaceConfig> iface;
    };
    std::optional<RouteInterface> interfaceOfDefaultRoute() noexcept;

    // Return first and last IP address in little-endian encoding, use HostToInet to convert in big-endian byte order for sin_addr.s_addr
    class IpRange {
    public:
        IpRange(const std::string& ip, const std::string& netmask);
        std::string network() const noexcept;
        std::string broadcast() const noexcept;
        std::string ip(size_t index) const noexcept;
        std::optional<size_t> indexOf(const std::string& ip) const noexcept;
        size_t hostCapacity() const noexcept;

        struct sockaddr_in sockaddr(size_t index) const noexcept;

    private:
        static std::string leToString(uint32_t leIp) noexcept;

    private:
        uint32_t leBegin_{0};
        uint32_t leEnd_{0};
        bool privateIp_{false};
    };

} // namespace quasar
