#pragma once

#include <functional>
#include <vector>

#include <linux/netlink.h>

namespace quasar::net {
    struct FdHolder {
        int fd;
        FdHolder(int f = -1);
        ~FdHolder();
    };

    std::array<char, 2> hexchar(unsigned char c);
    using MacAddress = std::array<std::uint8_t, 6>;
    std::string macToStr(const MacAddress& /*src*/);
    std::string rawDataToString(const void* dataIn, unsigned len);

    class NetlinkBase {
    public:
        using ProcessMessageFunc = std::function<void(const struct nlmsghdr*)>;
        using HandledRequest = std::tuple<std::function<void()>, ProcessMessageFunc>;

        NetlinkBase(int netlinkScope, int groups);

        void stop();
        void monitorImpl(bool indefinitelly,
                         std::vector<HandledRequest> initialRequests,
                         std::function<bool()> periodic = {});

        template <typename Request_>
        void setupHeader(Request_& req, int rtmRequest) {
            memset(&req, 0, sizeof(req));
            setupHeaderImpl(req.hdr, sizeof(req.gen), rtmRequest);
        }

        template <typename Request_>
        void sendRequest(Request_& req) {
            sendRequestImpl(&req, req.hdr.nlmsg_len);
        }

    private:
        void setupHeaderImpl(struct nlmsghdr& /*hdr*/, unsigned genLen, int rtmRequest);
        void sendRequestImpl(void* reqPtr, int reqLen);

        static constexpr unsigned BUF_SIZE = 81920;
        FdHolder sock;
        struct sockaddr_nl nlAddr;
        int seqNumber;
        const int procPidId;
        const int nlPidId;
        ProcessMessageFunc msgHandler;
        std::atomic_bool quit{false};

        struct ReadMsgStatus {
            bool done{false};
            bool read{false};
        };

        ReadMsgStatus readMsg(bool inRequest); // done, readed
    };
} // namespace quasar::net
