#pragma once

#include <linux/if_link.h>

#include <memory>
#include <string>

namespace quasar::net {
    class NetlinkMonitor {
    public:
        struct IfFlags {
            bool up = false;
            bool running = false;
            bool loopback = false;
            bool multicast = false;
            bool p2p = false;
            bool dynamic = false;

            std::string toString() const;
        };

        enum class Scope {
            UNIVERSAL,
            SITE = 200,
            LINK = 253,
            HOST = 254,
            NOWHERE = 255
        };

        struct Handler {
            using IfIndex = int;
            using Family = int;
            using Stats = rtnl_link_stats64;

            virtual void onAddress(IfIndex, std::string, Family, Scope, bool /*local*/) = 0;
            virtual void onAddressRemove(IfIndex, std::string, Family, Scope, bool /*local*/) = 0;
            virtual void onLink(IfIndex, std::string, IfFlags) = 0;
            virtual void onLinkRemoved(IfIndex) = 0;
            virtual void onMac(IfIndex, std::string) = 0;
            virtual void onStats(IfIndex, const Stats&) = 0;
            virtual ~Handler() = default;
        };

        virtual void monitor(bool indefinetelly, bool pollStats = false) = 0;
        virtual void stop() = 0;
        virtual ~NetlinkMonitor() = default;
    };

    std::unique_ptr<NetlinkMonitor> makeNetlinkMonitor(NetlinkMonitor::Handler& /*handler*/);
} // namespace quasar::net
