#pragma once

#include <optional>
#include <string>
#include <vector>

namespace quasar {

    struct NetworkInterface {
        std::string name;
        std::string address;
        enum class Family {
            IPV4,
            IPV6,
            PACKET,
            UNSPEC
        } family;

        NetworkInterface(std::string /*name*/, std::string /*address*/, Family /*f*/);
    };

    // loopback interface will not return
    std::vector<NetworkInterface> getActiveNetworkInterfaces();
    std::optional<std::string> getLocalAddressAsOptString();
    std::string getLocalAddress();
} // namespace quasar
