#include "resolve.h"

#include <yandex_io/libs/logging/logging.h>

#include <sys/types.h>
#include <netdb.h>

namespace {
    struct FreeAddrInfo {
        void operator()(addrinfo* info) {
            freeaddrinfo(info);
        }
    };
} // namespace

quasar::Resolves quasar::resolve(const std::string& host) {
    addrinfo hints;
    addrinfo* result;
    hints.ai_family = AF_UNSPEC;
    hints.ai_socktype = SOCK_DGRAM;
    hints.ai_flags = 0;
    hints.ai_protocol = 0;
    hints.ai_canonname = nullptr;
    hints.ai_addr = nullptr;
    hints.ai_next = nullptr;

    Resolves rval;

    if (auto err = getaddrinfo(host.c_str(), nullptr, &hints, &result)) {
        YIO_LOG_DEBUG("Failed to resolve " << host << " " << gai_strerror(err));
        return rval;
    }

    std::unique_ptr<addrinfo, FreeAddrInfo> lock(result);
    for (addrinfo* cur = result; cur != nullptr; cur = cur->ai_next) {
        if (cur->ai_family == AF_INET) {
            rval.ipv4.emplace_back();
            memcpy(&rval.ipv4.back(), cur->ai_addr, sizeof(rval.ipv4.back()));
        } else if (cur->ai_family == AF_INET6) {
            rval.ipv6.emplace_back();
            memcpy(&rval.ipv6.back(), cur->ai_addr, sizeof(rval.ipv6.back()));
        }
    };
    return rval;
}
