#pragma once

#include <functional>

#include <netdb.h>
#include <sys/poll.h>
#include <sys/socket.h>

struct addrinfo;
namespace quasar {

    struct NtpClientApi {
        std::function<int(const char*, const char*, const struct addrinfo*, struct addrinfo**)> getaddrinfo;
        std::function<void(struct addrinfo*)> freeaddrinfo;
        std::function<int(int, int, int)> socket;
        std::function<int(int, int, int, const void*, socklen_t)> setsockopt;
        std::function<void(int)> close;
        std::function<const char*(int, const void*, char*, socklen_t)> inet_ntop;
        std::function<ssize_t(int, const void*, size_t, int, const struct sockaddr*, socklen_t)> sendto;
        std::function<ssize_t(int, void*, size_t, int, struct sockaddr*, socklen_t*)> recvfrom;
        std::function<int(struct pollfd*, nfds_t, int)> poll;
    };

} // namespace quasar
