#pragma once
#include <stdint.h>

namespace quasar {

    // RFC 5905 https://tools.ietf.org/html/rfc5905#section-7.3
    struct NtpPacketRaw {
        uint8_t flags;
        uint8_t stratum;
        uint8_t poll;
        uint8_t precision;
        uint32_t root_delay;
        uint32_t root_dispersion;
        uint8_t referenceId[4];
        uint32_t ref_ts_sec;
        uint32_t ref_ts_frac;
        uint32_t origin_ts_sec;
        uint32_t origin_ts_frac;
        uint32_t recv_ts_sec;
        uint32_t recv_ts_frac;
        uint32_t trans_ts_sec;
        uint32_t trans_ts_frac;
    };

} // namespace quasar
