#pragma once

#include <chrono>
#include <stdexcept>
#include <string>

namespace quasar {

    class CurlPerformException: public std::runtime_error {
    public:
        CurlPerformException(const std::string& url, int curlErrorCode);
    };

    class NoTimestampHeader: public std::runtime_error {
    public:
        NoTimestampHeader(const std::string& url);
    };

    std::chrono::system_clock::time_point getUtcTimeOverHttp(const std::string& url, std::chrono::milliseconds timeout);

} // namespace quasar
