#pragma once

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <chrono>
#include <memory>
#include <string>

namespace quasar {

    class GatewayMonitor: public std::enable_shared_from_this<GatewayMonitor> {
    public:
        class Listener {
        public:
            virtual ~Listener() = default;

            virtual void onGatewayChanged(const std::string& oldIp, const std::string& newIp) = 0;
        };

        static std::string gatewayIp();

    public:
        GatewayMonitor(std::chrono::seconds reloadInterval, Listener* listener, ICallbackQueue* worker);

        static std::shared_ptr<GatewayMonitor> create(std::chrono::seconds reloadInterval, Listener* listener, ICallbackQueue* worker);

        void reloadNow();

    private:
        void reload();
        void reloadOnce();
        void scheduleNextReload();

    private:
        std::weak_ptr<GatewayMonitor> weakFromThis();

    private:
        const std::chrono::seconds reloadInterval_;

        Listener* listener_;

        ICallbackQueue* worker_;

        std::string gatewayIp_;
    };

} // namespace quasar
