#include "debug.h"

#include <google/protobuf/text_format.h>
#include <google/protobuf/io/zero_copy_stream_impl_lite.h>

#include <util/system/compiler.h>

#include <algorithm>
#include <memory>

namespace {

    using namespace google::protobuf;

    class MaskAuthTokenFieldValuePrinter: public TextFormat::FastFieldValuePrinter {
    public:
        void PrintFieldName(const Message& message, const Reflection* reflection, const FieldDescriptor* field,
                            TextFormat::BaseTextGenerator* generator) const override {
            static std::string MASKS[]{"auth_token", "xtoken", "oauth_token", "password"};

            if (field->type() == FieldDescriptor::TYPE_STRING) {
                if (std::find(std::begin(MASKS), std::end(MASKS), field->name()) != std::end(MASKS)) {
                    maskAuthToken_ = true;
                }
            }

            TextFormat::FastFieldValuePrinter::PrintFieldName(message, reflection, field, generator);
        }

        void PrintString(const TString& val, TextFormat::BaseTextGenerator* generator) const override {
            if (Y_UNLIKELY(maskAuthToken_)) {
                maskAuthToken_ = false;

                static const TString MASK = "********";
                TextFormat::FastFieldValuePrinter::PrintString(MASK, generator);
                return;
            }

            TextFormat::FastFieldValuePrinter::PrintString(val, generator);
        }

    private:
        mutable bool maskAuthToken_{false};
    };

} // namespace

using namespace quasar;

std::string quasar::shortUtf8DebugString(const google::protobuf::Message& message) {
    google::protobuf::TextFormat::Printer printer;
    printer.SetUseUtf8StringEscaping(true);
    printer.SetSingleLineMode(true);
    printer.SetUseShortRepeatedPrimitives(true);
    printer.SetExpandAny(true);

    auto fieldValuePrinter_ = std::make_unique<const MaskAuthTokenFieldValuePrinter>();
    printer.SetDefaultFieldValuePrinter(fieldValuePrinter_.release());

    TString result = "{ ";
    google::protobuf::io::StringOutputStream output(&result);
    printer.Print(message, &output);
    result += '}';

    return result;
}
