#include "json.h"

#include <google/protobuf/util/json_util.h>

std::optional<Json::Value> quasar::convertMessageToJson(const google::protobuf::Message& message, bool printPrimitives) {
    return quasar::tryParseJson(quasar::convertMessageToJsonString(message, printPrimitives));
}

std::string quasar::convertMessageToJsonString(const google::protobuf::Message& message, bool printPrimitives) {
    TString jsonString;
    google::protobuf::util::JsonPrintOptions printOptions;
    printOptions.always_print_primitive_fields = printPrimitives;
    google::protobuf::util::MessageToJsonString(message, &jsonString, printOptions);
    return jsonString;
}

std::string quasar::convertMessageToDeepJsonString(const google::protobuf::Message& message, bool printPrimitives) {
    auto json = convertMessageToJson(message, printPrimitives);
    if (json) {
        return jsonToString(recursiveExpandJson(std::move(*json)), true);
    }

    return "";
}

bool quasar::convertJsonToMessage(google::protobuf::Message* message, std::string_view jsonString, bool ignoreUnknownFields)
{
    if (!message) {
        return false;
    }
    google::protobuf::util::JsonParseOptions opt;
    opt.ignore_unknown_fields = ignoreUnknownFields;
    auto status = google::protobuf::util::JsonStringToMessage(jsonString, message, opt);
    return status.ok();
}
