#pragma once

#include <yandex_io/libs/json_utils/json_utils.h>

#include <google/protobuf/message.h>

#include <string>
#include <type_traits>

namespace quasar {

    /*
     * Param: printPrimitives
     *      Whether to always print primitive fields. By default proto3 primitive
     *      fields with default values will be omitted in JSON output. For example, an
     *      int32 field set to 0 will be omitted. Set this flag to true will override
     *      the default behavior and print primitive fields regardless of their values.
     * */
    std::optional<Json::Value> convertMessageToJson(const google::protobuf::Message& message, bool printPrimitives = false);
    std::string convertMessageToJsonString(const google::protobuf::Message& message, bool printPrimitives = false);
    std::string convertMessageToDeepJsonString(const google::protobuf::Message& message, bool printPrimitives = false);

    bool convertJsonToMessage(google::protobuf::Message* message, std::string_view jsonString, bool ignoreUnknownFields = false);

    template <class T>
    std::optional<T> convertJsonToProtobuf(std::string_view source, bool ignoreUnknownFields = false) {
        static_assert(std::is_base_of<google::protobuf::Message, T>::value);
        std::optional<T> pb;
        pb.emplace();
        if (!convertJsonToMessage(&(*pb), source, ignoreUnknownFields)) {
            pb = std::nullopt;
        }
        return pb;
    }
} // namespace quasar
