#pragma once

//
//  Helpful debug macros. Provide protobuf tracing in local debug builds.
//
//  Example usage:
//
//  if (message.has_foo()) {
//      __PROTOTRACE("some foo", message.foo());
//  }
//
//  prints to log
//
//  2019-Apr-29 22:33:34.934 <DEBUG> __PROTOTRACE [some foo]: [foo {
//    bar {
//      baz: 1
//    }
//  }]
//
//  TODO: add ability to enable it tag-wise during compile? time
//
#include "debug.h"

#include <yandex_io/libs/logging/logging.h>

#define __PROTOTRACE(TAG, P)                                                        \
    {                                                                               \
        YIO_LOG_TRACE("__PROTOTRACE [" << TAG << "]: " << shortUtf8DebugString(P)); \
    }
