#pragma once

#include <yandex_io/libs/rate_limiter/rate_limiter.h>

#include <yandex_io/libs/threading/periodic_executor.h>

#include <chrono>
#include <deque>
#include <mutex>
#include <string>
#include <unordered_map>
#include <unordered_set>

namespace quasar {

    class BucketRateLimiter: public RateLimiter {
    public:
        struct OverflowInfo {
            std::string event;
            uint32_t limit;
            uint32_t eventCount;

            bool operator==(const OverflowInfo& rhs) const;
        };

        BucketRateLimiter(uint32_t bucketsCount,
                          uint32_t limit,
                          std::unordered_set<std::string> filteredEvents);

        ~BucketRateLimiter();

        void setOverflowOnBucketRotatingCb(std::function<void(const OverflowInfo&)> overflowOnBucketRotatingCb);
        void setRotatingBucketsPeriod(std::chrono::milliseconds rotatingBucketsPeriod);

        void start() override;
        void stop() override;

        [[nodiscard]] BucketRateLimiter::OverflowStatus addEvent(const std::string& event) override;

    protected:
        void rotateBuckets();

    private:
        class EventCounter {
        public:
            explicit EventCounter(uint32_t bucketsCount);
            void addEvent();
            void rotateBuckets();
            uint32_t total() const;

        private:
            std::deque<uint32_t> bucketCounters_;
            uint32_t total_{0};
        };

        std::unordered_map<std::string, EventCounter> counters_;
        std::unique_ptr<quasar::PeriodicExecutor> bucketRotator_;
        std::mutex mutex_;

        std::chrono::milliseconds rotatingBucketsPeriod_{1000};

        const uint32_t limit_;
        std::function<void(const OverflowInfo&)> overflowOnBucketRotatingCb_;
    };

} // namespace quasar
