#pragma once

#include <string>

namespace quasar {

    class RateLimiter {
    public:
        enum class OverflowStatus {
            OVERFLOWED,
            NOT_OVERFLOWED
        };

        virtual void start() = 0;
        virtual void stop() = 0;

        virtual OverflowStatus addEvent(const std::string& event) = 0;

        virtual ~RateLimiter();
    };

} // namespace quasar
