#pragma once

#include <memory>

namespace quasar {

    /**
     * @brief Ring buffer class template
     * @tparam T Type to store in the buffer
     *
     * Simple ring buffer implementation. No erase, just write and (non-destructive) read.
     * Stores last RingBuffer#capacity written bytes.
     * Values are read from the beginning of buffer.
     */
    template <typename T>
    class RingBuffer {
    public:
        using SharedPtr = std::shared_ptr<RingBuffer<T>>;

    public:
        explicit RingBuffer(size_t capacity);
        RingBuffer(const RingBuffer&) = delete;
        RingBuffer& operator=(const RingBuffer&) = delete;
        ~RingBuffer();
        size_t write(const T* data, size_t length);
        size_t read(T* target, size_t length) const;
        size_t getSize() const;
        size_t getCapacity() const;
        size_t getFree() const;
        void clear();

    private:
        T* buffer;
        const size_t capacity;
        size_t begin;
        size_t end;
        bool empty;
    };

} // namespace quasar

#include "ring_buffer_inl.h"
