#include "rss_memory_counter.h"

#include <yandex_io/libs/logging/logging.h>

#include <boost/algorithm/string.hpp>

#include <fstream>
#include <sstream>
#include <stdlib.h>

#include <unistd.h>

using namespace quasar;

RssMemoryCounter::RssMemoryCounter()
    : pageSizeKb_(sysconf(_SC_PAGESIZE) / 1024)
{
}

namespace {
    constexpr int statFieldsCount = 23;
} // namespace

ssize_t RssMemoryCounter::count(int pid) const {
    std::stringstream statPathStream;
    statPathStream << "/proc/" << pid << "/stat";
    const std::string smapsPath = statPathStream.str();
    std::ifstream procStat;
    procStat.open(smapsPath);
    if (!procStat.good()) {
        YIO_LOG_WARN("Unable get stat of proc " << pid);
        return -1;
    }

    std::string procStatLine;
    std::getline(procStat, procStatLine);

    std::vector<std::string> stat_fields;
    boost::iter_split(stat_fields, procStatLine, boost::first_finder(" "));
    if (stat_fields.size() < statFieldsCount) {
        YIO_LOG_WARN("Expected " << statFieldsCount << " stat items, but received only " << stat_fields.size() << ", pid: "
                                 << pid << ". Stat: " << procStatLine);
        return -1;
    }

    return atoll(stat_fields[statFieldsCount].c_str()) * pageSizeKb_;
}

std::string RssMemoryCounter::getMetricName() const {
    return "freeRss";
}
