#pragma once

#include "self_destroyer_predicate.h"

#include <yandex_io/libs/self_destroyer/memory_counter/memory_counter.h>

#include <yandex_io/libs/device/device.h>

namespace quasar {

    class MemoryCounterSelfDestroyerPredicate: public SelfDestroyerPredicate {
    public:
        MemoryCounterSelfDestroyerPredicate(size_t limitKb, std::shared_ptr<MemoryCounter> memoryCounter, bool reportDifference,
                                            std::shared_ptr<YandexIO::IDevice> device, std::string processName);

        SelfDestroyerPredicate::Result checkNeedDestroySelf() const override;

    private:
        const ssize_t limitKB_;
        std::shared_ptr<MemoryCounter> memoryCounter_;
        bool reportDifference_;
        std::shared_ptr<YandexIO::IDevice> device_;
        std::string processName_;
        const int pid_;
    };

} // namespace quasar
