#include "self_destroyer.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <signal.h>

#include <unistd.h>

YIO_DEFINE_LOG_MODULE("self_destroyer");

using namespace quasar;

SelfDestroyer::SelfDestroyer(
    std::string processName,
    std::unique_ptr<SelfDestroyerPredicate> predicate,
    std::shared_ptr<YandexIO::IDevice> device)
    : pid_(::getpid())
    , processName_(processName)
    , predicate_(std::move(predicate))
    , device_(std::move(device))
{
}

void SelfDestroyer::destroySelfIfNeed() const {
    const auto result = predicate_->checkNeedDestroySelf();
    if (!result.shouldDestroy) {
        return;
    }
    YIO_LOG_ERROR_EVENT("SelfDestroyer.Destroy", "Process " << processName_ << " will be killed: " << result.reason);
    doDestroy();
}

void SelfDestroyer::doDestroy() const {
    Json::Value eventValue;
    eventValue["process"] = processName_;
    device_->telemetry()->reportEvent("process_suicide", jsonToString(eventValue));
    std::this_thread::sleep_for(std::chrono::seconds(3));
    ::kill(pid_, SIGKILL);
    throw;
}
