#pragma once

#include "never_self_destroyer_predicate.h"
#include "self_destroyer_predicate.h"

#include <yandex_io/libs/device/device.h>

#include <memory>

namespace quasar {

    class SelfDestroyer {
    public:
        SelfDestroyer(
            std::string processName,
            std::unique_ptr<SelfDestroyerPredicate> predicate,
            std::shared_ptr<YandexIO::IDevice> device);

        void destroySelfIfNeed() const;

    private:
        [[noreturn]] void doDestroy() const;

    private:
        const pid_t pid_;
        const std::string processName_;
        const std::unique_ptr<SelfDestroyerPredicate> predicate_;
        std::shared_ptr<YandexIO::IDevice> device_;
    };

} // namespace quasar
