#include "self_destroyer_utils.h"

#include "memory_counter_self_destroyer_predicate.h"

#include <yandex_io/libs/self_destroyer/memory_counter/rss_memory_counter.h>

#include <yandex_io/libs/json_utils/json_utils.h>

using namespace quasar;

std::shared_ptr<SelfDestroyer> SelfDestroyerUtils::create(
    const std::string& processName,
    std::shared_ptr<YandexIO::IDevice> device,
    const std::string& serviceName) {
    const auto deviceConfiguration = device->configuration();
    const auto& serviceConfig = deviceConfiguration->getServiceConfig(serviceName);
    return std::make_shared<SelfDestroyer>(
        processName,
        std::make_unique<MemoryCounterSelfDestroyerPredicate>(
            tryGetInt(serviceConfig, "memoryLimitRssKB", std::numeric_limits<int>::max()),
            std::make_shared<RssMemoryCounter>(), true, device, processName),
        std::move(device));
}

std::shared_ptr<SelfDestroyer> SelfDestroyerUtils::createStub(
    std::shared_ptr<YandexIO::IDevice> device) {
    return std::make_shared<SelfDestroyer>(
        "",
        std::make_unique<NeverSelfDestroyerPredicate>(),
        std::move(device));
}
