#pragma once

#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <iostream>
#include <mutex>
#include <queue>
#include <thread>
#include <vector>

namespace quasar {

    class AudioStream {
    public:
        AudioStream();

        ~AudioStream();

        /*
         * Returns true if read is successful and false otherwise
         */
        bool read(std::vector<std::int16_t>& buffer, size_t size);

        void write(const std::vector<std::int16_t>& buffer);

        void clear();

        void stop();

        void start();

    private:
        bool stopped_;
        std::queue<std::int16_t> queue_;
        std::mutex mutex_;
        quasar::SteadyConditionVariable cond_;
    };

} // namespace quasar
