#include "credentials.h"

#include "wifi_type.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <sstream>

YIO_DEFINE_LOG_MODULE("setup_parser");

using namespace quasar::SetupParser;
using namespace quasar::WifiType;

Credentials::Credentials(int wifiType, const std::vector<std::string>& SSIDs, short SSIDHashCode, std::string password,
                         std::string tokenCode)
{
    if (isWifiTypeValid(wifiType) == false) {
        throw std::logic_error("Input wifi type is invalid: " + std::to_string(wifiType));
    }

    this->wifiType = wifiType;
    this->SSIDs = SSIDs;
    this->SSIDHashCode = SSIDHashCode;
    this->password = std::move(password);
    this->tokenCode = std::move(tokenCode);

    this->isInitialized = true; // Why?
}

std::string Credentials::toString() const {
    std::stringstream ss;
    ss << "Credentials{ wifiType=" << std::to_string(wifiType) << ", SSID='" << join(SSIDs, ", ") + '\'' << ", SSIDHashCode=" << std::to_string(SSIDHashCode) << ", password='" << password << '\'' << ", tokenCode='" << tokenCode << "'}";
    return ss.str();
}

void Credentials::fillSSIDs(const google::protobuf::RepeatedPtrField<proto::WifiInfo>& hotSpotsList) {
    std::vector<std::string> ssids;

    int cnt = 0;
    for (const proto::WifiInfo& wifiInfo : hotSpotsList)
    {
        try {
            cnt++;
            YIO_LOG_DEBUG(" -WIFI ssid: " << wifiInfo.ssid());
            short hashCode = javaStyleStringHash(wifiInfo.ssid());
            YIO_LOG_DEBUG(" -WIFI hash: " << hashCode << ", rec: " << this->SSIDHashCode);
            if (hashCode == this->SSIDHashCode)
            {
                ssids.push_back(wifiInfo.ssid());
            }
        } catch (const std::logic_error& error) {
            YIO_LOG_ERROR_EVENT("SetupCredentials.GetSSIDHashFailed", "Can't get SSID hash code: " << error.what());
        }
    }
    YIO_LOG_INFO("WIFI list len: " << cnt);
    this->SSIDs = ssids;
}
