#pragma once

#include <yandex_io/protos/quasar_proto.pb.h>

#include <string>
#include <vector>

namespace quasar::SetupParser {
    struct Credentials {
        bool isInitialized{false};
        int wifiType;
        std::vector<std::string> SSIDs;
        short SSIDHashCode;
        std::string password;
        std::string tokenCode;

        Credentials() = default;

        Credentials(int wifiType, const std::vector<std::string>& SSIDs, short SSIDHashCode, std::string password,
                    std::string tokenCode);

        std::string toString() const;
        void fillSSIDs(const google::protobuf::RepeatedPtrField<proto::WifiInfo>& hotSpotsList);
    };
} // namespace quasar::SetupParser
