#include "encoder_decoder.h"

#include "sound_utils.h"

#include <yandex_io/libs/error_correcting_code/galois_field.h>
#include <yandex_io/libs/error_correcting_code/reed_solomon_decoder.h>
#include <yandex_io/libs/error_correcting_code/reed_solomon_encoder.h>

using namespace quasar;

EncoderDecoder::EncoderDecoder()
{
    encoder_ = ReedSolomonEncoder(SoundUtils::GALOIS_FIELD);
    decoder_ = ReedSolomonDecoder(SoundUtils::GALOIS_FIELD);
}

std::vector<unsigned char>
EncoderDecoder::encodeData(const std::vector<unsigned char>& data, int numErrorCorrectionBytes) const {
    if (data.size() == 0)
    {
        return std::vector<unsigned char>();
    }

    std::vector<unsigned char> bos;
    uint offset = 0;
    while (offset < data.size())
    {
        int remaining = data.size() - offset;
        int toEncodeSize;
        if (remaining + numErrorCorrectionBytes > quasar::SoundUtils::MAX_BYTES_PER_CHUNK)
        {
            toEncodeSize = quasar::SoundUtils::MAX_BYTES_PER_CHUNK - numErrorCorrectionBytes;
        } else {
            toEncodeSize = remaining;
        }
        std::vector<unsigned char> toEncode(data.begin() + offset, data.begin() + offset + toEncodeSize);
        offset += toEncode.size();
        std::vector<int> dataInts(toEncode.size() + numErrorCorrectionBytes);
        for (uint i = 0; i < toEncode.size(); i++)
        {
            dataInts[i] = toEncode[i];
        }
        encoder_.encode(dataInts, numErrorCorrectionBytes);

        for (int it : dataInts)
        {
            bos.push_back((unsigned char)(it));
        }
    }

    return bos;
}

std::vector<unsigned char> EncoderDecoder::decodeData(const std::vector<unsigned char>& data,
                                                      int numErrorCorrectionBytes) const {
    if (data.empty())
    {
        return std::vector<unsigned char>();
    }

    std::vector<unsigned char> res;
    uint offset = 0;
    while (offset < data.size())
    {
        int remaining = data.size() - offset;

        int toDecodeSize;
        if (remaining > quasar::SoundUtils::MAX_BYTES_PER_CHUNK)
        {
            toDecodeSize = quasar::SoundUtils::MAX_BYTES_PER_CHUNK;
        } else {
            toDecodeSize = remaining;
        }
        std::vector<unsigned char> toDecode(data.begin() + offset, data.begin() + offset + toDecodeSize);
        offset += toDecode.size();

        std::vector<int> dataInts(toDecode.size());

        for (uint i = 0; i < toDecode.size(); i++)
        {
            dataInts[i] = toDecode[i];
        }

        decoder_.decode(dataInts, numErrorCorrectionBytes);

        for (int i = 0; i < (int)dataInts.size() - numErrorCorrectionBytes; i++)
        {
            res.push_back(dataInts[i]);
        }
    }

    return res;
}
