#pragma once

#include <yandex_io/libs/error_correcting_code/reed_solomon_decoder.h>
#include <yandex_io/libs/error_correcting_code/reed_solomon_encoder.h>

/**
 *
 * <p>Port to C++ of Akimov Sergey's implementation.</p>
 *
 * @author Sergey Akimov (akiserg@yandex-team.ru)
 * @author katayad (katayad@yandex-team.ru)
 */

namespace quasar {

    class EncoderDecoder {
    private:
        ReedSolomonEncoder encoder_;
        ReedSolomonDecoder decoder_;

    public:
        EncoderDecoder();

        std::vector<unsigned char> encodeData(const std::vector<unsigned char>& data, int numErrorCorrectionBytes) const;

        std::vector<unsigned char> decodeData(const std::vector<unsigned char>& data, int numErrorCorrectionBytes) const;
    };

} // namespace quasar
